/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.datamodel.impl;

import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTreeModel;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Node;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.tree.SimpleTreeNode;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.NodeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;

public class MutableCachingTreeModelTreeImpl
implements PmTreeModel {
    private static final String TRACE_MASKT = "XPMDTEMT";
    private static final String TRACE_MASKF = "XPMDTEMF";
    private NodeDescriptor invisibleRootNode = new NodeDescriptor("Invisible Root Node", "Invisible Root Node");
    private Node modelRoot;
    PmDataBean bean;
    Method setTreeParent;
    Method getChildren;
    Method getSelection;
    Method setSelection;
    private static final Class[] CLASS_ARGS_SET_TREE_PARENT = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MutableCachingTreeModelTreeImpl.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] CLASS_ARGS_SET_SELECTION = new Class[]{array$Lcom$ibm$ui$framework$NodeDescriptor == null ? (array$Lcom$ibm$ui$framework$NodeDescriptor = MutableCachingTreeModelTreeImpl.class$("[Lcom.ibm.ui.framework.NodeDescriptor;")) : array$Lcom$ibm$ui$framework$NodeDescriptor};
    private SimpleTreeNode cachedTreeRoot = new SimpleTreeNode(this.invisibleRootNode);
    private TreePath[] cachedSelection = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Lcom$ibm$ui$framework$NodeDescriptor;

    public MutableCachingTreeModelTreeImpl(Node modelRoot) {
        Trace.trace(TRACE_MASKF, "MCTRTI: <ctor> root node is: " + modelRoot);
        this.modelRoot = modelRoot;
        this.invisibleRootNode.setExpandRequested(true);
    }

    public String getModelId() {
        String id = this.modelRoot.getId();
        return id == null ? "" : id;
    }

    public void init() {
        Trace.trace(TRACE_MASKF, "MCTRTI: init()");
        this.bean = this.modelRoot.getPanelModel().getDataBean();
        if (!(this.bean instanceof DataBean)) {
            Trace.trace(TRACE_MASKF, "MCTRTI: PmDataBean was not an AUIML bean!");
            this.bean = null;
        } else {
            String hmcid = this.modelRoot.fetchAttribute("hmc", "model", false);
            if (hmcid != null) {
                hmcid = hmcid.substring(0, hmcid.indexOf("_model"));
                hmcid = hmcid.substring(0, 1).toUpperCase() + hmcid.substring(1);
            } else {
                Trace.trace(TRACE_MASKT, "MCTRTI: missing hmcid attribute????");
            }
            try {
                this.setTreeParent = this.bean.getClass().getMethod("set" + hmcid + "TreeParent", CLASS_ARGS_SET_TREE_PARENT);
                this.getChildren = this.bean.getClass().getMethod("get" + hmcid + "Children", null);
                this.getSelection = this.bean.getClass().getMethod("get" + hmcid + "Selection", null);
                this.setSelection = this.bean.getClass().getMethod("set" + hmcid + "Selection", CLASS_ARGS_SET_SELECTION);
                Trace.trace(TRACE_MASKF, "tree methods appear ok");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "MCTRTI: PmDataBean did not have appropriate AUIML tree methods! : " + e.getMessage());
                Trace.trace(TRACE_MASKF, "trying lowercase methods");
                if (hmcid != null) {
                    hmcid = hmcid.substring(0, 1).toLowerCase() + hmcid.substring(1);
                    try {
                        this.setTreeParent = this.bean.getClass().getMethod("set" + hmcid + "TreeParent", CLASS_ARGS_SET_TREE_PARENT);
                        this.getChildren = this.bean.getClass().getMethod("get" + hmcid + "Children", null);
                        this.getSelection = this.bean.getClass().getMethod("get" + hmcid + "Selection", null);
                        this.setSelection = this.bean.getClass().getMethod("set" + hmcid + "Selection", CLASS_ARGS_SET_SELECTION);
                        Trace.trace(TRACE_MASKF, "lowercase methods appear ok");
                    }
                    catch (Exception e2) {
                        Trace.trace(TRACE_MASKT, "MCTRTI: PmDataBean did not have appropriate AUIML tree methods! : " + e2.getMessage());
                    }
                }
                Trace.trace(TRACE_MASKT, "MCTRTI: missing hmcid attribute (in exception path)????");
            }
        }
        this.refresh();
    }

    public void refresh() {
        this.populateTreeFromBean();
        this.populateSelectionFromBean();
    }

    private void populateTreeFromBean() {
        block4: {
            Trace.trace(TRACE_MASKF, "MCTRTI: populateTreeFromBean()");
            this.cachedTreeRoot.removeAll();
            if (this.bean == null || this.setTreeParent == null || this.getChildren == null) break block4;
            try {
                this.setTreeParent.invoke((Object)this.bean, (Object[])new String[]{null});
                NodeDescriptor[] rootNodes = (NodeDescriptor[])this.getChildren.invoke((Object)this.bean, null);
                if (rootNodes != null) {
                    int i = 0;
                    while (i < rootNodes.length) {
                        SimpleTreeNode newNode = new SimpleTreeNode(rootNodes[i]);
                        this.cachedTreeRoot.add(newNode);
                        this.populateSubTreeFromBean(newNode, rootNodes[i]);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void populateSubTreeFromBean(SimpleTreeNode parentTree, NodeDescriptor parentND) {
        block4: {
            if (parentTree == null || parentND == null) {
                return;
            }
            try {
                this.setTreeParent.invoke((Object)this.bean, (Object[])new String[]{parentND.getName()});
                NodeDescriptor[] nodes = (NodeDescriptor[])this.getChildren.invoke((Object)this.bean, null);
                if (nodes == null) break block4;
                int i = 0;
                while (i < nodes.length) {
                    SimpleTreeNode newNode = new SimpleTreeNode(nodes[i]);
                    parentTree.add(newNode);
                    this.populateSubTreeFromBean(newNode, nodes[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getChildCount(Object parent) {
        Trace.trace(TRACE_MASKF, "MCTRTI: getChildCount ( " + parent + " )");
        if (this.cachedTreeRoot == null) {
            Trace.trace(TRACE_MASKF, "MCTRTI: getChildCount ( " + parent + " ) cachedTreeRoot == null");
            return 0;
        }
        if (parent == null) {
            return 0;
        }
        SimpleTreeNode tempNode = this.findNodeForObject(this.cachedTreeRoot, parent);
        if (tempNode == null) {
            return 0;
        }
        return tempNode.getChildCount();
    }

    private SimpleTreeNode findNodeForObject(SimpleTreeNode tempRoot, Object desiredObject) {
        if (tempRoot == null) {
            return null;
        }
        if (tempRoot.getUserObject() == null && desiredObject == null) {
            return tempRoot;
        }
        if (tempRoot.getUserObject() != null && tempRoot.getUserObject().equals(desiredObject)) {
            return tempRoot;
        }
        if (tempRoot.hasChildren()) {
            List tempRootChildren = tempRoot.getChildren();
            Iterator iterator = tempRootChildren.iterator();
            while (iterator.hasNext()) {
                SimpleTreeNode tempChild = (SimpleTreeNode)iterator.next();
                SimpleTreeNode returnVal = this.findNodeForObject(tempChild, desiredObject);
                if (returnVal == null) continue;
                return returnVal;
            }
        }
        return null;
    }

    public Object getRoot() {
        Trace.trace(TRACE_MASKF, "MCTRTI: getRoot()");
        return this.invisibleRootNode;
    }

    public boolean containsHmcId(String id) {
        return false;
    }

    public Object getValueByHmcId(String id) {
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        Trace.trace(TRACE_MASKF, "MCTRTI: getIndexOfChild( " + parent + " , " + child + " )");
        if (this.bean != null && this.setTreeParent != null && this.getChildren != null) {
            SimpleTreeNode parentNode = this.findNodeForObject(this.cachedTreeRoot, parent);
            SimpleTreeNode childNode = this.findNodeForObject(parentNode, child);
            if (parent == null || child == null) {
                Trace.trace(TRACE_MASKF, "MCTRTI: getIndexOfChild returns -1 (parent == null) || (child == null)");
                return -1;
            }
            int childCount = parentNode.getChildCount();
            int i = 0;
            while (i < childCount) {
                SimpleTreeNode tempChild = parentNode.getChildAt(i);
                if (tempChild != null && tempChild.equals(childNode)) {
                    Trace.trace(TRACE_MASKF, "MCTRTI: getIndexOfChild returns: " + i);
                    return i;
                }
                ++i;
            }
            Trace.trace(TRACE_MASKF, "MCTRTI: getIndexOfChild returns -1 (couldn't find child)");
            return -1;
        }
        return -1;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        Trace.trace(TRACE_MASKF, "MCTRTI: valueForPathChanged( " + path + " , " + newValue + " )");
    }

    public Object getChild(Object parent, int index) {
        Trace.trace(TRACE_MASKF, "MCTRTI: getChild( " + parent + " , " + index + " )");
        if (this.bean != null && this.setTreeParent != null && this.getChildren != null) {
            if (parent == null || index < 0) {
                throw new IllegalArgumentException("Parameter to getChild() was invalid!  [" + parent + "," + index + "]");
            }
            SimpleTreeNode parentNode = this.findNodeForObject(this.cachedTreeRoot, parent);
            if (parentNode == null) {
                Trace.trace(TRACE_MASKF, "MCTRTI: getChild returns null (parentNode == null)");
                return null;
            }
            if (parentNode.getChildCount() <= index) {
                Trace.trace(TRACE_MASKF, "MCTRTI: getChild returns null (parentNode.getChildCount() <= index)");
                return null;
            }
            return parentNode.getChildAt(index).getUserObject();
        }
        return null;
    }

    public boolean isLeaf(Object node) {
        Trace.trace(TRACE_MASKF, "MCTRTI: isLeaf( " + node + " )");
        if (node instanceof NodeDescriptor) {
            Trace.trace(TRACE_MASKF, "MCTRTI: isLeaf returns: " + ((NodeDescriptor)node).isLeaf());
            return ((NodeDescriptor)node).isLeaf();
        }
        if (this.bean != null && this.setTreeParent != null && this.getChildren != null) {
            SimpleTreeNode treeNode = this.findNodeForObject(this.cachedTreeRoot, node);
            return treeNode == null ? true : treeNode.getChildCount() == 0;
        }
        return true;
    }

    public void setSelected(TreePath[] selected) {
        Trace.trace(TRACE_MASKF, "MCTRTI: setSelected(" + selected + ")");
        this.cachedSelection = selected;
        this.setSelectionIntoBean();
    }

    public TreePath[] getSelected() {
        Trace.trace(TRACE_MASKF, "MCTRTI: getSelected()");
        return this.cachedSelection;
    }

    private void setSelectionIntoBean() {
        block5: {
            Trace.trace(TRACE_MASKF, "MCTRTI: setSelectionIntoBean() ");
            if (this.bean == null || this.setSelection == null) break block5;
            try {
                NodeDescriptor[] descriptors = null;
                if (this.cachedSelection != null) {
                    descriptors = new NodeDescriptor[this.cachedSelection.length];
                    int i = 0;
                    while (i < this.cachedSelection.length) {
                        descriptors[i] = this.cachedSelection[i] == null ? new NodeDescriptor("", null) : (NodeDescriptor)this.cachedSelection[i].getLastPathComponent();
                        ++i;
                    }
                } else {
                    descriptors = new NodeDescriptor[]{};
                }
                this.setSelection.invoke((Object)this.bean, new Object[]{descriptors});
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "Exception in setSelected(): " + e.getMessage());
            }
        }
    }

    private void populateSelectionFromBean() {
        Trace.trace(TRACE_MASKF, "MCTRTI: populateSelectionFromBean()");
        if (this.bean != null && this.getSelection != null) {
            try {
                NodeDescriptor[] descriptors = (NodeDescriptor[])this.getSelection.invoke((Object)this.bean, null);
                if (descriptors == null) {
                    this.cachedSelection = new TreePath[0];
                } else {
                    this.cachedSelection = new TreePath[descriptors.length];
                    int i = 0;
                    while (i < descriptors.length) {
                        this.cachedSelection[i] = descriptors[i] == null ? null : this.buildTreePathFromNodeDescriptor(descriptors[i]);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "Exception in populateSelectionFromBean(): " + e.getMessage());
                this.cachedSelection = new TreePath[0];
            }
        } else {
            this.cachedSelection = new TreePath[0];
        }
    }

    private TreePath buildTreePathFromNodeDescriptor(NodeDescriptor descriptor) throws Exception {
        TreePath treePath = null;
        ArrayList<Object> treePathNodes = null;
        try {
            SimpleTreeNode tempNode = this.findNodeForObject(this.cachedTreeRoot, descriptor);
            if (tempNode != null) {
                treePathNodes = new ArrayList<Object>();
                SimpleTreeNode tempParent = tempNode.getParent();
                while (tempParent != null) {
                    treePathNodes.add(0, tempParent.getUserObject());
                    tempParent = tempParent.getParent();
                }
            }
            if (treePathNodes != null) {
                int treePathNodesSize = treePathNodes.size();
                Object[] treePathArgs = new Object[treePathNodesSize];
                int i = 0;
                while (i < treePathNodesSize) {
                    treePathArgs[i] = treePathNodes.get(i);
                    ++i;
                }
                treePath = new TreePath(treePathArgs);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception in buildTreePathFromNodeDescriptor(): " + e.getMessage());
        }
        return treePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

